import matplotlib.pyplot as plt
import seaborn as sns
import os
from sklearn.preprocessing import LabelEncoder
from sklearn.model_selection import train_test_split
from sklearn.metrics import classification_report, confusion_matrix
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import accuracy_score
from sklearn.preprocessing import StandardScaler
from sklearn.cluster import KMeans
from sklearn.metrics import silhouette_score
import numpy as np
from scipy import stats
import sys
sys.path.append(sys.argv[1])

import pandas as pd   
import pickle


# Load the dataset    
fastfood = pd.read_csv(os.path.join(sys.argv[1], 'fastfood.csv'))  

# Assuming the dataset is loaded as a DataFrame named 'fastfood'   
keywords = ['sandwich', 'wrap', 'salad', 'burger', 'burrito', 'taco']   
   
# Make the filtering case-insensitive   
fastfood['item_lower'] = fastfood['item'].str.lower()   
   
# Filter the dataset using the keywords   
filtered_fastfood = fastfood[fastfood['item_lower'].str.contains('|'.join(keywords))]   
   
# Drop the 'item_lower' column as it's not needed anymore   
filtered_fastfood = filtered_fastfood.drop(columns=['item_lower'])   

print(filtered_fastfood)
# pickle.dump(filtered_fastfood,open("./ref_result/filtered_fastfood.pkl","wb"))


 
import pandas as pd   
import pickle
   
# Assuming the dataset is loaded as a DataFrame named 'fastfood'   
   
# Recommended Daily Intake (RDI) values   
rdi_protein = 50   
rdi_fiber = 25   
rdi_vit_a = 5000   
rdi_vit_c = 60   
rdi_calcium = 1000   
rdi_sat_fat = 20   
rdi_trans_fat = 2   
rdi_sugar = 50   
rdi_sodium = 2400   
rdi_total_carb = 300   
   
# Calculate the percentage of RDI for each nutrient   
fastfood['protein_score'] = (fastfood['protein'] / rdi_protein) * 100   
fastfood['fiber_score'] = (fastfood['fiber'] / rdi_fiber) * 100   
fastfood['vit_a_score'] = (fastfood['vit_a'] / rdi_vit_a) * 100   
fastfood['vit_c_score'] = (fastfood['vit_c'] / rdi_vit_c) * 100   
fastfood['calcium_score'] = (fastfood['calcium'] / rdi_calcium) * 100   
fastfood['sat_fat_score'] = (fastfood['sat_fat'] / rdi_sat_fat) * 100   
fastfood['trans_fat_score'] = (fastfood['trans_fat'] / rdi_trans_fat) * 100   
fastfood['sugar_score'] = (fastfood['sugar'] / rdi_sugar) * 100   
fastfood['sodium_score'] = (fastfood['sodium'] / rdi_sodium) * 100   
fastfood['total_carb_score'] = (fastfood['total_carb'] / rdi_total_carb) * 100   
   
# Calculate the Comprehensive Modified NRF Index   
fastfood['comprehensive_modified_nrf_index'] = (fastfood['protein_score'] + fastfood['fiber_score'] + fastfood['vit_a_score'] + fastfood['vit_c_score'] + fastfood['calcium_score']) - (fastfood['sat_fat_score'] + fastfood['trans_fat_score'] + fastfood['sugar_score'] + fastfood['sodium_score'] + fastfood['total_carb_score']) 

print(fastfood)
# pickle.dump(fastfood,open("./ref_result/fastfood.pkl","wb"))


